
/* Result Sets Interface */
#ifndef SQL_CRSR
#  define SQL_CRSR
  struct sql_cursor
  {
    unsigned int curocn;
    void *ptr1;
    void *ptr2;
    unsigned long magic;
  };
  typedef struct sql_cursor sql_cursor;
  typedef struct sql_cursor SQL_CURSOR;
#endif /* SQL_CRSR */

/* Thread Safety */
typedef void * sql_context;
typedef void * SQL_CONTEXT;

/* Object support */
struct sqltvn
{
  unsigned char *tvnvsn; 
  unsigned short tvnvsnl; 
  unsigned char *tvnnm;
  unsigned short tvnnml; 
  unsigned char *tvnsnm;
  unsigned short tvnsnml;
};
typedef struct sqltvn sqltvn;

struct sqladts
{
  unsigned int adtvsn; 
  unsigned short adtmode; 
  unsigned short adtnum;  
  sqltvn adttvn[1];       
};
typedef struct sqladts sqladts;

static struct sqladts sqladt = {
  1,1,0,
};

/* Binding to PL/SQL Records */
struct sqltdss
{
  unsigned int tdsvsn; 
  unsigned short tdsnum; 
  unsigned char *tdsval[1]; 
};
typedef struct sqltdss sqltdss;
static struct sqltdss sqltds =
{
  1,
  0,
};

/* File name & Package Name */
struct sqlcxp
{
  unsigned short fillen;
           char  filnam[17];
};
static struct sqlcxp sqlfpn =
{
    16,
    "Populate_Poly.pc"
};


static unsigned long sqlctx = 5224323;


static struct sqlexd {
   unsigned int   sqlvsn;
   unsigned int   arrsiz;
   unsigned int   iters;
   unsigned int   offset;
   unsigned short selerr;
   unsigned short sqlety;
   unsigned int   unused;
            short *cud;
   unsigned char  *sqlest;
            char  *stmt;
   sqladts *sqladtp;
   sqltdss *sqltdsp;
            void  **sqphsv;
   unsigned int   *sqphsl;
            int   *sqphss;
            void  **sqpind;
            int   *sqpins;
   unsigned int   *sqparm;
   unsigned int   **sqparc;
   unsigned short  *sqpadto;
   unsigned short  *sqptdso;
            void  *sqhstv[6];
   unsigned int   sqhstl[6];
            int   sqhsts[6];
            void  *sqindv[6];
            int   sqinds[6];
   unsigned int   sqharm[6];
   unsigned int   *sqharc[6];
   unsigned short  sqadto[6];
   unsigned short  sqtdso[6];
} sqlstm = {10,6};

/* SQLLIB Prototypes */
extern sqlcxt (/*_ void **, unsigned long *,
                   struct sqlexd *, struct sqlcxp * _*/);
extern sqlcx2t(/*_ void **, unsigned long *,
                   struct sqlexd *, struct sqlcxp * _*/);
extern sqlbuft(/*_ void **, char * _*/);
extern sqlgs2t(/*_ void **, char * _*/);
extern sqlorat(/*_ void **, unsigned long *, void * _*/);

/* Forms Interface */
static int IAPSUCC = 0;
static int IAPFAIL = 1403;
static int IAPFTL  = 535;
extern void sqliem(/*_ char *, int * _*/);

typedef struct { unsigned short len; unsigned char arr[1]; } VARCHAR;
typedef struct { unsigned short len; unsigned char arr[1]; } varchar;

/* CUD (Compilation Unit Data) Array */
static short sqlcud0[] =
{10,4130,0,0,0,
5,0,0,1,0,0,27,89,0,0,4,4,0,1,0,1,97,0,0,1,10,0,0,1,10,0,0,1,10,0,0,
36,0,0,2,152,0,3,107,0,0,6,6,0,1,0,1,97,0,0,1,97,0,0,1,4,0,0,1,4,0,0,1,4,0,0,1,
3,0,0,
75,0,0,3,86,0,3,121,0,0,2,2,0,1,0,1,3,0,0,1,4,0,0,
98,0,0,4,0,0,30,146,0,0,0,0,0,1,0,
};



/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
/* Populate_Poly.pc                                        */
/* 	Load to the NCEDC database the polynomial info.    */
/*      Errors can be found on Error.log                   */
/*                                                         */
/* Zuzlewski Stephane @1999                                */
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* EXEC SQL INCLUDE sqlca.h;
 */ 
/*
 * $Header: sqlca.h,v 1.3 1994/12/12 19:27:27 jbasu Exp $ sqlca.h 
 */

/* Copyright (c) 1985,1986 by Oracle Corporation. */
 
/*
NAME
  SQLCA : SQL Communications Area.
FUNCTION
  Contains no code. Oracle fills in the SQLCA with status info
  during the execution of a SQL stmt.
NOTES
  **************************************************************
  ***                                                        ***
  *** This file is SOSD.  Porters must change the data types ***
  *** appropriately on their platform.  See notes/pcport.doc ***
  *** for more information.                                  ***
  ***                                                        ***
  **************************************************************

  If the symbol SQLCA_STORAGE_CLASS is defined, then the SQLCA
  will be defined to have this storage class. For example:
 
    #define SQLCA_STORAGE_CLASS extern
 
  will define the SQLCA as an extern.
 
  If the symbol SQLCA_INIT is defined, then the SQLCA will be
  statically initialized. Although this is not necessary in order
  to use the SQLCA, it is a good pgming practice not to have
  unitialized variables. However, some C compilers/OS's don't
  allow automatic variables to be init'd in this manner. Therefore,
  if you are INCLUDE'ing the SQLCA in a place where it would be
  an automatic AND your C compiler/OS doesn't allow this style
  of initialization, then SQLCA_INIT should be left undefined --
  all others can define SQLCA_INIT if they wish.

  If the symbol SQLCA_NONE is defined, then the SQLCA variable will
  not be defined at all.  The symbol SQLCA_NONE should not be defined
  in source modules that have embedded SQL.  However, source modules
  that have no embedded SQL, but need to manipulate a sqlca struct
  passed in as a parameter, can set the SQLCA_NONE symbol to avoid
  creation of an extraneous sqlca variable.
 
MODIFIED
    jbasu      12/12/94 -  Bug 217878: note this is an SOSD file
    losborne   08/11/92 -  No sqlca var if SQLCA_NONE macro set 
  Clare      12/06/84 - Ch SQLCA to not be an extern.
  Clare      10/21/85 - Add initialization.
  Bradbury   01/05/86 - Only initialize when SQLCA_INIT set
  Clare      06/12/86 - Add SQLCA_STORAGE_CLASS option.
*/
 
#ifndef SQLCA
#define SQLCA 1
 
struct   sqlca
         {
         /* ub1 */ char    sqlcaid[8];
         /* b4  */ long    sqlabc;
         /* b4  */ long    sqlcode;
         struct
           {
           /* ub2 */ unsigned short sqlerrml;
           /* ub1 */ char           sqlerrmc[70];
           } sqlerrm;
         /* ub1 */ char    sqlerrp[8];
         /* b4  */ long    sqlerrd[6];
         /* ub1 */ char    sqlwarn[8];
         /* ub1 */ char    sqlext[8];
         };

#ifndef SQLCA_NONE 
#ifdef   SQLCA_STORAGE_CLASS
SQLCA_STORAGE_CLASS struct sqlca sqlca
#else
         struct sqlca sqlca
#endif
 
#ifdef  SQLCA_INIT
         = {
         {'S', 'Q', 'L', 'C', 'A', ' ', ' ', ' '},
         sizeof(struct sqlca),
         0,
         { 0, {0}},
         {'N', 'O', 'T', ' ', 'S', 'E', 'T', ' '},
         {0, 0, 0, 0, 0, 0},
         {0, 0, 0, 0, 0, 0, 0, 0},
         {0, 0, 0, 0, 0, 0, 0, 0}
         }
#endif
         ;
#endif
 
#endif
 
/* end SQLCA */



typedef char asciz[20];
typedef char vc2_arr[11];

  /* EXEC SQL BEGIN DECLARE SECTION; */ 

  /* User-defined type for null-terminated strings */
  /* EXEC SQL TYPE asciz  IS STRING(20) REFERENCE; */ 


  /* User-defined type for a VARCHAR array element */
  /* EXEC SQL TYPE vc2_arr IS VARCHAR2(11) REFERENCE; */ 


  asciz		username;
  asciz		password;

  char		user_pwd[80];
  int	i;
  int	j;
  int	k;
  char	pname[81];	/* Polynomial name */
  char  ptype[32];      /* Polynomial type */
  float lower;          /* Polynomial lower bound */
  float upper;          /* Polynomial upper bound */
  float maxerror;       /* Maximum error of polynomial approximation */
  int   nb_coeff;       /* Number of coefficients */
  float pncoeff;        /* Polynomial coefficients */

  /* EXEC SQL END DECLARE SECTION; */ 



long		SQLCODE;
FILE*		f_err;		/* Error File descriptor */

void		sql_error();	/* handles unrecoverable errors */


						  /*-*-*-*-*-*-*-*-*/
						 /* Main function */
						/*-*-*-*-*-*-*-*-*/
main (argc, argv)
int	argc;
char*	argv[];
{
 FILE*	f_poly; 	/* Polynomial file descriptor */
 char	line[1025]; 	/* Line information */
 char	header[7];	/* Header */

 float	pn_coeff[21];	/* Polynomial coefficients */

 
 /* Opening the error file */
 if ((f_err = fopen ("Error.log", "w+t")) == NULL)
	{
	 printf ("\n Error [File (Error.log) could not be opened].\n\n");

	 exit (0);
	}

 /* Opening the poly file */
 if ((f_poly = fopen ("poly.tbl", "rt")) == NULL)
	{
	 printf ("\n Error [File (poly.tbl) could not be opened].\n\n");

	 exit (0);
	}


 /* Connect to ORACLE. */
 /* EXEC SQL WHENEVER SQLERROR DO sql_error(); */ 


 strcpy (username, "ncedcdba");
 strcpy (password, "passwd");
 strcpy (user_pwd, "ncedcdba/passwd@ncedc");

 /* EXEC SQL CONNECT :user_pwd; */ 

{
 struct sqlexd sqlstm;

 sqlstm.sqlvsn = 10;
 sqlstm.arrsiz = 4;
 sqlstm.sqladtp = &sqladt;
 sqlstm.sqltdsp = &sqltds;
 sqlstm.iters = (unsigned int  )10;
 sqlstm.offset = (unsigned int  )5;
 sqlstm.cud = sqlcud0;
 sqlstm.sqlest = (unsigned char  *)&sqlca;
 sqlstm.sqlety = (unsigned short)0;
 sqlstm.sqhstv[0] = (         void  *)user_pwd;
 sqlstm.sqhstl[0] = (unsigned int  )80;
 sqlstm.sqhsts[0] = (         int  )80;
 sqlstm.sqindv[0] = (         void  *)0;
 sqlstm.sqinds[0] = (         int  )0;
 sqlstm.sqharm[0] = (unsigned int  )0;
 sqlstm.sqadto[0] = (unsigned short )0;
 sqlstm.sqtdso[0] = (unsigned short )0;
 sqlstm.sqphsv = sqlstm.sqhstv;
 sqlstm.sqphsl = sqlstm.sqhstl;
 sqlstm.sqphss = sqlstm.sqhsts;
 sqlstm.sqpind = sqlstm.sqindv;
 sqlstm.sqpins = sqlstm.sqinds;
 sqlstm.sqparm = sqlstm.sqharm;
 sqlstm.sqparc = sqlstm.sqharc;
 sqlstm.sqpadto = sqlstm.sqadto;
 sqlstm.sqptdso = sqlstm.sqtdso;
 sqlcxt((void **)0, &sqlctx, &sqlstm, &sqlfpn);
 SQLCODE = sqlca.sqlcode;
 if (sqlca.sqlcode < 0) sql_error();
}



 printf ("\n Connected to ORACLE as user: %s\n", username);


 /* Parsing poly file */
 fgets (line, 1024, f_poly);

 while (!feof (f_poly))
	{
	 strcpy (header, "");
	 sscanf (line, "%s", header);

	 if (!strcmp (header, "POLY"))
		{
                 /* Reading polynomial information */
                 sscanf (line, "%*s %s %s %f %f %f %d", pname, ptype, &lower, &upper, &maxerror, &nb_coeff);

                 /* EXEC SQL INSERT INTO Response_PN (pn_id, name, poly_type, lower_bound, upper_bound, max_error, nb_coeff, lddate)
                 VALUES (pnseq.NEXTVAL, :pname, :ptype, :lower, :upper, :maxerror, :nb_coeff, SYSDATE); */ 

{
                 struct sqlexd sqlstm;

                 sqlstm.sqlvsn = 10;
                 sqlstm.arrsiz = 6;
                 sqlstm.sqladtp = &sqladt;
                 sqlstm.sqltdsp = &sqltds;
                 sqlstm.stmt = "insert into Response_PN(pn_id,name,poly_type\
,lower_bound,upper_bound,max_error,nb_coeff,lddate) values (pnseq.nextval ,:b0\
,:b1,:b2,:b3,:b4,:b5,sysdate )";
                 sqlstm.iters = (unsigned int  )1;
                 sqlstm.offset = (unsigned int  )36;
                 sqlstm.cud = sqlcud0;
                 sqlstm.sqlest = (unsigned char  *)&sqlca;
                 sqlstm.sqlety = (unsigned short)0;
                 sqlstm.sqhstv[0] = (         void  *)pname;
                 sqlstm.sqhstl[0] = (unsigned int  )81;
                 sqlstm.sqhsts[0] = (         int  )0;
                 sqlstm.sqindv[0] = (         void  *)0;
                 sqlstm.sqinds[0] = (         int  )0;
                 sqlstm.sqharm[0] = (unsigned int  )0;
                 sqlstm.sqadto[0] = (unsigned short )0;
                 sqlstm.sqtdso[0] = (unsigned short )0;
                 sqlstm.sqhstv[1] = (         void  *)ptype;
                 sqlstm.sqhstl[1] = (unsigned int  )32;
                 sqlstm.sqhsts[1] = (         int  )0;
                 sqlstm.sqindv[1] = (         void  *)0;
                 sqlstm.sqinds[1] = (         int  )0;
                 sqlstm.sqharm[1] = (unsigned int  )0;
                 sqlstm.sqadto[1] = (unsigned short )0;
                 sqlstm.sqtdso[1] = (unsigned short )0;
                 sqlstm.sqhstv[2] = (         void  *)&lower;
                 sqlstm.sqhstl[2] = (unsigned int  )4;
                 sqlstm.sqhsts[2] = (         int  )0;
                 sqlstm.sqindv[2] = (         void  *)0;
                 sqlstm.sqinds[2] = (         int  )0;
                 sqlstm.sqharm[2] = (unsigned int  )0;
                 sqlstm.sqadto[2] = (unsigned short )0;
                 sqlstm.sqtdso[2] = (unsigned short )0;
                 sqlstm.sqhstv[3] = (         void  *)&upper;
                 sqlstm.sqhstl[3] = (unsigned int  )4;
                 sqlstm.sqhsts[3] = (         int  )0;
                 sqlstm.sqindv[3] = (         void  *)0;
                 sqlstm.sqinds[3] = (         int  )0;
                 sqlstm.sqharm[3] = (unsigned int  )0;
                 sqlstm.sqadto[3] = (unsigned short )0;
                 sqlstm.sqtdso[3] = (unsigned short )0;
                 sqlstm.sqhstv[4] = (         void  *)&maxerror;
                 sqlstm.sqhstl[4] = (unsigned int  )4;
                 sqlstm.sqhsts[4] = (         int  )0;
                 sqlstm.sqindv[4] = (         void  *)0;
                 sqlstm.sqinds[4] = (         int  )0;
                 sqlstm.sqharm[4] = (unsigned int  )0;
                 sqlstm.sqadto[4] = (unsigned short )0;
                 sqlstm.sqtdso[4] = (unsigned short )0;
                 sqlstm.sqhstv[5] = (         void  *)&nb_coeff;
                 sqlstm.sqhstl[5] = (unsigned int  )4;
                 sqlstm.sqhsts[5] = (         int  )0;
                 sqlstm.sqindv[5] = (         void  *)0;
                 sqlstm.sqinds[5] = (         int  )0;
                 sqlstm.sqharm[5] = (unsigned int  )0;
                 sqlstm.sqadto[5] = (unsigned short )0;
                 sqlstm.sqtdso[5] = (unsigned short )0;
                 sqlstm.sqphsv = sqlstm.sqhstv;
                 sqlstm.sqphsl = sqlstm.sqhstl;
                 sqlstm.sqphss = sqlstm.sqhsts;
                 sqlstm.sqpind = sqlstm.sqindv;
                 sqlstm.sqpins = sqlstm.sqinds;
                 sqlstm.sqparm = sqlstm.sqharm;
                 sqlstm.sqparc = sqlstm.sqharc;
                 sqlstm.sqpadto = sqlstm.sqadto;
                 sqlstm.sqptdso = sqlstm.sqtdso;
                 sqlcxt((void **)0, &sqlctx, &sqlstm, &sqlfpn);
                 SQLCODE = sqlca.sqlcode;
                 if (sqlca.sqlcode < 0) sql_error();
}



                 printf ("\n POLY : %s\t%s\t%f\t%f\t%f\t%d", pname, ptype, lower, upper, maxerror, nb_coeff);

                 /* Reading polynomial coefficients */
                 sscanf (line, "%*s %*s %*s %*s %*s %*s %*s %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f", &pn_coeff[0], &pn_coeff[1], &pn_coeff[2], &pn_coeff[3], &pn_coeff[4], &pn_coeff[5], &pn_coeff[6], &pn_coeff[7], &pn_coeff[8], &pn_coeff[9], &pn_coeff[10], &pn_coeff[11], &pn_coeff[12], &pn_coeff[13], &pn_coeff[14], &pn_coeff[15],
&pn_coeff[16], &pn_coeff[17], &pn_coeff[18], &pn_coeff[19]);

                 printf ("\n\t\t\t Coefficients : ");
                 for (k=0;k<nb_coeff;k++)
                 	{
                         pncoeff = pn_coeff[k];
 
                         /* EXEC SQL INSERT INTO Response_PN_Data (pn_id, pn_nb, pn_value)
                         VALUES (pnseq.CURRVAL, :k+1, :pncoeff); */ 

{
                         struct sqlexd sqlstm;

                         sqlstm.sqlvsn = 10;
                         sqlstm.arrsiz = 6;
                         sqlstm.sqladtp = &sqladt;
                         sqlstm.sqltdsp = &sqltds;
                         sqlstm.stmt = "insert into Response_PN_Data(pn_id,p\
n_nb,pn_value) values (pnseq.currval ,(:b0+1),:b1)";
                         sqlstm.iters = (unsigned int  )1;
                         sqlstm.offset = (unsigned int  )75;
                         sqlstm.cud = sqlcud0;
                         sqlstm.sqlest = (unsigned char  *)&sqlca;
                         sqlstm.sqlety = (unsigned short)0;
                         sqlstm.sqhstv[0] = (         void  *)&k;
                         sqlstm.sqhstl[0] = (unsigned int  )4;
                         sqlstm.sqhsts[0] = (         int  )0;
                         sqlstm.sqindv[0] = (         void  *)0;
                         sqlstm.sqinds[0] = (         int  )0;
                         sqlstm.sqharm[0] = (unsigned int  )0;
                         sqlstm.sqadto[0] = (unsigned short )0;
                         sqlstm.sqtdso[0] = (unsigned short )0;
                         sqlstm.sqhstv[1] = (         void  *)&pncoeff;
                         sqlstm.sqhstl[1] = (unsigned int  )4;
                         sqlstm.sqhsts[1] = (         int  )0;
                         sqlstm.sqindv[1] = (         void  *)0;
                         sqlstm.sqinds[1] = (         int  )0;
                         sqlstm.sqharm[1] = (unsigned int  )0;
                         sqlstm.sqadto[1] = (unsigned short )0;
                         sqlstm.sqtdso[1] = (unsigned short )0;
                         sqlstm.sqphsv = sqlstm.sqhstv;
                         sqlstm.sqphsl = sqlstm.sqhstl;
                         sqlstm.sqphss = sqlstm.sqhsts;
                         sqlstm.sqpind = sqlstm.sqindv;
                         sqlstm.sqpins = sqlstm.sqinds;
                         sqlstm.sqparm = sqlstm.sqharm;
                         sqlstm.sqparc = sqlstm.sqharc;
                         sqlstm.sqpadto = sqlstm.sqadto;
                         sqlstm.sqptdso = sqlstm.sqtdso;
                         sqlcxt((void **)0, &sqlctx, &sqlstm, &sqlfpn);
                         SQLCODE = sqlca.sqlcode;
                         if (sqlca.sqlcode < 0) sql_error();
}


         
                         printf ("%f\t", pn_coeff[k]);
                        }

		}

	 fgets (line, 1024, f_poly);
	}


 fprintf (f_err, "\n");
 printf ("\n\n");

 /* Closing error file */
 fclose (f_err);

 /* Closing poly file */
 fclose (f_poly);


 /* Disconnect from the database */
 printf ("\n Disconnecting from ORACLE ...\n\n");

 /* EXEC SQL COMMIT WORK RELEASE; */ 

{
 struct sqlexd sqlstm;

 sqlstm.sqlvsn = 10;
 sqlstm.arrsiz = 6;
 sqlstm.sqladtp = &sqladt;
 sqlstm.sqltdsp = &sqltds;
 sqlstm.iters = (unsigned int  )1;
 sqlstm.offset = (unsigned int  )98;
 sqlstm.cud = sqlcud0;
 sqlstm.sqlest = (unsigned char  *)&sqlca;
 sqlstm.sqlety = (unsigned short)0;
 sqlcxt((void **)0, &sqlctx, &sqlstm, &sqlfpn);
 SQLCODE = sqlca.sqlcode;
 if (sqlca.sqlcode < 0) sql_error();
}



 exit(0);
}

  /*************************************/
 /* Handle errors. Exit on any error. */
/*************************************/
void sql_error()
{
 char msg[512];
 size_t buf_len, msg_len;


 /* EXEC SQL WHENEVER SQLERROR CONTINUE; */ 


 buf_len = sizeof(msg);
 sqlglm(msg, &buf_len, &msg_len);

 fprintf(f_err, "\nORACLE error detected:");
 fprintf(f_err, "\n%.*s \n", msg_len, msg);

 printf("\nORACLE error detected:");
 printf("\n%.*s \n", msg_len, msg);

 /*EXEC SQL ROLLBACK WORK RELEASE;
 exit(1);*/
}

